unit DatumDlg;

interface

uses
  SysUtils, Windows, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, Grids, Calendar, ExtCtrls;

type
  TDatumFrm = class(TForm)
    Naptar: TCalendar;
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    Bevel1: TBevel;
    Honapok: TComboBox;
    Evek: TComboBox;
    procedure FormCreate(Sender: TObject);
    procedure HonapokChange(Sender: TObject);
    procedure EvekChange(Sender: TObject);
  public
    function DatumString: ShortString;
  end;

var
  DatumFrm: TDatumFrm;

procedure GetDatum(HLeiro: THandle; var SDatum: ShortString); Stdcall;

implementation

{$R *.DFM}
var
  HonapNevek : Array[1..12] of ShortString =
           ('Janur', 'Februr', 'Mrcius', 'prilis',
            'Mjus', 'Jnius', 'Jlius', 'Augusztus',
            'Szeptember', 'Oktber', 'November', 'December');

{ A Datum ellltsa v.h.nap formban}
function TDatumFrm.DatumString: ShortString;
var tar : ShortString;
begin
  with Naptar do
   begin
     Result :=  IntToStr(Year)+ '.';
     Tar :='0'+IntToStr(Month);
     Result := result + Copy(Tar, Length(Tar)-1,2) + '.';
     Tar :='0'+IntToStr(Day);
     Result := result + Copy(Tar, Length(Tar)-1,2) + '.';
  end;
end;

{ A prbeszdablak elemeinek inicializlsa }
procedure TDatumFrm.FormCreate(Sender: TObject);
var
  i: Integer;
begin
  for i := 1 to 12 do
    Honapok.Items.Add(HonapNevek[i]);
  Honapok.ItemIndex := Naptar.Month - 1;
  for i := 1900 to 2100 do
    Evek.Items.Add(IntToStr(i));
  Evek.ItemIndex := Evek.Items.IndexOf(IntToStr(Naptar.Year));
end;

{ hnap kijellse }
procedure TDatumFrm.HonapokChange(Sender: TObject);
begin
  Naptar.Month := Honapok.ItemIndex + 1;
end;

{ v kijellse }
procedure TDatumFrm.EvekChange(Sender: TObject);
begin
  Naptar.Year := StrToInt(Evek.Items.Strings[Evek.ItemIndex]);
end;

{ A DLL kvlrl hvhat eljrsa, amely ltrehozza
  s megjelenti a prbeszdablakot}
procedure GetDatum(HLeiro: THandle; var SDatum: ShortString); stdcall;
begin
  Application.Handle := HLeiro;
  DatumFrm := TDatumFrm.Create(Application);
  if DatumFrm.ShowModal <> mrCancel then
     SDatum := DatumFrm.DatumString
  else
     SDatum := '0000.00.00.';
  DatumFrm.Free;
end;

end.
